/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.aerials;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import net.forixaim.battle_arts.core_assets.animations.AnimationHelpers;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.capabilities.styles.ImperatriceLumiereStyles;
import net.forixaim.battle_arts.core_assets.skills.BattleArtsDataKeys;
import net.forixaim.bs_api.battle_arts_skills.aerials.MidAirAttack;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class ImperatriceAerials
extends MidAirAttack {
    private static final AnimationProvider<AttackAnimation> NEUTRAL_AERIAL = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_NEUTRAL_AERIAL;
    private static final AnimationProvider<AttackAnimation> FORWARD_AERIAL = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_FORWARD_AERIAL;
    private static final AnimationProvider<AttackAnimation> DOWN_AERIAL = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_DOWN_AERIAL;

    public ImperatriceAerials(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public static Skill.Builder<ImperatriceAerials> createImperatriceAerialBuilder() {
        return new Skill.Builder().setCategory((SkillCategory)SkillCategories.AIR_ATTACK).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executer.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92085_) ? 1 : 0;
        int backward = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92087_) ? -1 : 0;
        int left = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92086_) ? 1 : 0;
        int right = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92088_) ? -1 : 0;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(forward);
        buf.writeInt(backward);
        buf.writeInt(left);
        buf.writeInt(right);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        int forward = args.readInt();
        int backward = args.readInt();
        int left = args.readInt();
        int right = args.readInt();
        int vertic = forward + backward;
        int horizon = left + right;
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(Integer.compare(vertic, 0));
        packet.getBuffer().writeInt(Integer.compare(horizon, 0));
        return packet;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        return !player.m_20159_() && AnimationHelpers.isInAir(executer) && playerState.canBasicAttack();
    }

    public boolean canExecute(PlayerPatch<?> executor) {
        if (executor.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle(executor) == ImperatriceLumiereStyles.IMPERATRICE_SWORD) {
            return super.canExecute(executor) && executor.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) && (Boolean)executor.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) == false;
        }
        return super.canExecute(executor);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)executer) == ImperatriceLumiereStyles.IMPERATRICE_SWORD || executer.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)executer).equals((Object)ImperatriceLumiereStyles.FORIXAIM_SWORD)) {
            int fw = args.readInt();
            int sw = args.readInt();
            StaticAnimation attackMotion = null;
            if (((ServerPlayer)executer.getOriginal()).m_6144_()) {
                LogUtils.getLogger().debug("Down Aerial");
                attackMotion = DOWN_AERIAL.get();
            } else if (fw == 1) {
                LogUtils.getLogger().debug("Forward Aerial");
                attackMotion = FORWARD_AERIAL.get();
            } else if (fw == -1) {
                LogUtils.getLogger().debug("Back Aerial");
            } else if (sw == 1) {
                LogUtils.getLogger().debug("Left Aerial");
            } else if (sw == -1) {
                LogUtils.getLogger().debug("Right Aerial");
            } else {
                LogUtils.getLogger().debug("Neutral Aerial");
                attackMotion = NEUTRAL_AERIAL.get();
            }
            if (attackMotion != null) {
                executer.playAnimationSynchronized(attackMotion, 0.0f);
            }
        } else {
            super.executeOnServer(executer, args);
        }
    }
}

